﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using TwoCamWPF.Helpers;
using System.Windows.Forms;
using System.Reflection;
namespace TwoCamWPF.Settings.SettingsPage
{
    /// <summary>
    /// Логика взаимодействия для RecordSettingsPage.xaml
    /// </summary>
    public partial class RecordSettingsPage : System.Windows.Controls.UserControl
    {
        public RecordSettingsPage()
        {
            InitializeComponent();
            Log.LogClass.Enqueue(MethodBase.GetCurrentMethod(), "Инициализация панели RecordSettingsPage");
      
        }

        private void button1_Click(object sender, RoutedEventArgs e)
        {
            using (FolderBrowserDialog dialog = new FolderBrowserDialog())
            {
                dialog.Description = "Папка для хранения архива";
                dialog.ShowNewFolderButton = true;
                dialog.SelectedPath=System.IO.Path.GetDirectoryName(
                    
                    System.Windows.Forms.Application.ExecutablePath);//Environment.SpecialFolder..MyComputer;
            Label_1:
                if (dialog.ShowDialog() == DialogResult.OK) 
                    if (DirectoryWriteChecker.Process(dialog.SelectedPath))
                        textBox2.Text = dialog.SelectedPath;
                    else
                        goto Label_1;
            }
        }


        private void button2_Click(object sender, RoutedEventArgs e)
        {
            using (FolderBrowserDialog dialog = new FolderBrowserDialog())
            {
                dialog.Description = "Папка для хранения избранных записей";
                dialog.ShowNewFolderButton = true;
                dialog.SelectedPath = System.IO.Path.GetDirectoryName(

                    System.Windows.Forms.Application.ExecutablePath);//Environment.SpecialFolder..MyComputer;
            Label_1:
                if (dialog.ShowDialog() == DialogResult.OK)
                    if (DirectoryWriteChecker.Process(dialog.SelectedPath))
                        textBox1.Text = dialog.SelectedPath;
                    else
                        goto Label_1;
            }
        }
    }

    class RecordSettingsModel : BaseViewModel<RecordSettings>, ISavedBasedViewModel
    {

        public RecordSettingsModel(RecordSettings settings)
            : base(settings)
        {
            _SaveFolder = settings.SaveFolder;
            _FilesCount = settings.FilesCount;
            _FileLength = settings.FileLength;
            _FavoritFolder = settings.FavoritFolder;
            _BitRate = settings.BitRate;
            settings.OnSave += (_) => Save();
        }

        string _SaveFolder;
        public string SaveFolder
        {

            get { return _SaveFolder; }
            set
            {
                _SaveFolder = value;
                RaisePropertyChanged("SaveFolder");
            }
        }

        int _FilesCount=5;
        public int FilesCount
        {
            get { return _FilesCount; }
            set
            {
                _FilesCount = value;
                RaisePropertyChanged("FilesCount");
            }
        }

        int _FileLength=5;
        public int FileLength
        {
            get { return _FileLength; }
            set
            {
                _FileLength = value;
                RaisePropertyChanged("FileLength");
            }
        }

        string _FavoritFolder;
        public string FavoritFolder
        {
            get { return _FavoritFolder; }
            set
            {
                _FavoritFolder = value;
                RaisePropertyChanged("FavoritFolder");
            }
        }
       
        int _BitRate=5;
        public int BitRate
        {
            get { return _BitRate; }
            set
            {
                _BitRate = value;
                RaisePropertyChanged("BitRate");
            }
        }


        void Save()
        {
            if (DirectoryWriteChecker.Process(_SaveFolder))
                _settings.SaveFolder = _SaveFolder;
            _settings.FilesCount = _FilesCount;
            _settings.FileLength = _FileLength;
            if (DirectoryWriteChecker.Process(_FavoritFolder))
                _settings.FavoritFolder = _FavoritFolder;
            _settings.BitRate = _BitRate;
        }

        public void Dispose()
        {

        }
    }
}
